/*:ja
 * @plugindesc ゲージ表示プラグイン
 * @author TRS
 * 
 * @param -----ゲージの基本設定-----
 * @desc セパレータ
 *
 * @param ゲージピクチャ番号
 * @desc ゲージのピクチャ番号の開始位置
 * 指定先と指定先から1つ先の番号を取得します
 * @type number
 * @max 100
 * @min 1
 * @default 1
 *
 * @param ゲージ枠ピクチャ名
 * @desc ゲージに使う枠
 * @type file
 * @require 1
 * @dir img/pictures
 *
 * @param ゲージ内部ピクチャ名
 * @desc ゲージ内部ピクチャ（ゲージ最大のもの）
 * @type file
 * @require 1
 * @dir img/pictures
 *
 * @param ゲージタイプ
 * @desc 1…左から右 2……下から上
 * @type number
 * @min 1
 * @max 2
 * @type number
 * @default 1
 *
 * @param 現在値格納変数
 * @desc  現在値が格納されてる変数ID
 * @type variable
 * @default 300
 *
 * @param 最大値格納変数
 * @desc ゲージMAX時の数値
 * @type variable
 * @default 156
 *
 * @param -----ゲージ個別設定-----
 * @desc セパレータ
 *
 * @param ゲージ枠X座標
 * @desc ゲージの横位置(原点左上)
 * @type number
 * @max 1000
 * @min -1000
 * @default 0
 *
 * @param ゲージ枠Y座標
 * @desc ゲージの縦位置(原点左上)
 * @type number
 * @max 700
 * @min -700
 * @default 0
 *
 *
 *
 * @help
 * スイッチでピクチャによるゲージを表示します
 *
 * *-----------------------------
 *  プラグインコマンド
 * 
 *  ゲージ表示更新
 *  
 *  ゲージの表示と更新を呼ばれる毎に行います。（主に並列処理）
 *
 *
 *  ゲージ消去
 *
 *  ゲージを完全消去します
 *
 */
 (function()
{
	var parameters = PluginManager.parameters('Gage');
	var param = {};
	
	//ゲージの基本設定
	param.pictureNo = Number( parameters['ゲージピクチャ番号'] || 1 );
	param.gageWaku = String( parameters['ゲージ枠ピクチャ名'] );
	param.gageInner = String( parameters['ゲージ内部ピクチャ名'] );
	param.gageAttri = Number( parameters['ゲージタイプ'] );
	param.gageNowVal = Number( parameters['現在値格納変数'] || 300 );
	param.gageMaxPoint = Number( parameters['最大値格納変数'] || 156 );
	
	//ゲージ個別設定
	param.gageXpos = Number( parameters['ゲージ枠X座標'] || 500 );
	param.gageYpos = Number( parameters['ゲージ枠Y座標'] || 600 );
	
	
	//var oldGageFileName = "";
	
	//-----------------------------------------------------------------------------
    //	 Game_Interpreter (プラグインコマンド用インタプリタ)
    //
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	
    Game_Interpreter.prototype.pluginCommand = function(command, args)
	{
		_Game_Interpreter_pluginCommand.call(this, command, args);
		
		//ゲージ更新
		if(command === "ゲージ表示更新")
		{
			this.gageUpdate();
		}
		else if( command === "ゲージ消去" )
		{
			this.delGage();
		}
	}
	/**
	 * ゲージの更新管理
	 */
	Game_Interpreter.prototype.gageUpdate = function()
	{
		this.initDrawGage();			//初期描画
		this.updateDrawGage();			//フレーム毎描画
		
	}
	
	/**
	 * ゲージの表示と更新
	 */
	Game_Interpreter.prototype.initDrawGage = function()
	{
		//最初処理
		if( this.oldGageFileName !== param.gageWaku)
		{
			switch( param.gageAttri )
			{ 
				case 1:
					this.InitLeftToRight();
					break;
				
				case 2:
					this.InitBottomToTop();
					break;
			}
			
			this.oldGageFileName = param.gageWaku;
			this.wrkBitmap = ImageManager.loadPicture(param.gageInner);
			
		}
		
		
	}
	
	/**
	 * ゲージ横左から右用初期配置
	 */
	Game_Interpreter.prototype.LeftToRight = function()
	{
		$gameScreen.showPicture(param.pictureNo, param.gageWaku, 0, param.gageXpos, param.gageYpos, 100, 100, 255, 0);
		$gameScreen.showPicture(param.pictureNo + 1, param.gageInner, 0, param.gageXpos, param.gageYpos, 0, 100, 255, 0);
	}
	
	/**
	 * ゲージ縦下からから上用初期配置
	 */
	Game_Interpreter.prototype.InitBottomToTop = function()
	{
		$gameScreen.showPicture(param.pictureNo, param.gageWaku, 0, param.gageXpos, param.gageYpos, 100, 100, 255, 0);
		$gameScreen.showPicture(param.pictureNo + 1, param.gageInner, 0, param.gageXpos, param.gageYpos, 100, 0, 255, 0);
	}
	
	/**
	 * フレーム毎ゲージ描画
	 */
	Game_Interpreter.prototype.updateDrawGage = function()
	{
		var varPoint = Number( $gameVariables.value( param.gageMaxPoint ) )
	
		var varWariai = ( Number( $gameVariables.value( param.gageNowVal ) ) / varPoint ) * 100;
		
		this.gageWidth = this.wrkBitmap._image.width;			//読み込んだ幅の更新（最初に0が来るため更新）
		this.gageHeight = this.wrkBitmap._image.height;			//読み込んだ高さの更新(最初に0が来るため更新)
		
		//
		if(varWariai >= varPoint )
		{
			varWariai = varPoint;
		}
		//割合が0以下になったら0を入れる
		else if( varWariai <= 0)
		{
			varWariai = 0;
		}
		
		switch( param.gageAttri )
		{ 
			case 1:
				this.updateLeftToRight(varWariai);
				break;
				
			case 2:
				this.updateBottomToTop(varWariai);
				break;
		}
		
	}
	
	/**
	 * フレーム毎左から右の横ゲージ描画
	 */
	Game_Interpreter.prototype.updateLeftToRight = function( varWariai )
	{
		$gameScreen.movePicture(param.pictureNo + 1, 0, param.gageXpos, param.gageYpos, varWariai, 100, 255, 0, 1 );
	}
	
	/**
	 * フレーム毎下から上の縦ゲージ描画
	 */
	Game_Interpreter.prototype.updateBottomToTop = function( varWariai )
	{
		var varInitposY = param.gageYpos + this.gageHeight;		//0の時の初期位置
		var wrkAddposY = varInitposY - this.gageHeight * ( varWariai / 100 );
		
		
		$gameScreen.movePicture(param.pictureNo + 1, 0, param.gageXpos, wrkAddposY, 100, varWariai, 255, 0, 1 );
		
	}
	
	/**
	 * 消す処理
	 */
	Game_Interpreter.prototype.delGage = function()
	{
		this.wait(1);
		$gameScreen.erasePicture(param.pictureNo);
		$gameScreen.erasePicture(param.pictureNo + 1);
		
		this.oldGageFileName = "";

	}
})();
